module Main where

import Runner
import Test.HUnit
import System.CPUTime

main :: IO Counts
main = runTestTT $ TestList [
  TestLabel "testDictSizes" testDictSizes,
  TestLabel "testWordSizes" testWordSizes,
  TestLabel "testNumberGames" testNumberGames
  ]

testDictSizes :: Test
testDictSizes = TestCase $ do 
  -- large dictionary test
  largeStartTime <- getCPUTime
  largeDictResults <- simulateGames "data/large_dict.txt" 8 50
  largeDictResults `seq` return ()
  largeEndTime <- getCPUTime
  let largeDictTime = (largeEndTime - largeStartTime)
  
  -- medium dictionary test
  mediumStartTime <- getCPUTime
  mediumDictResults <- simulateGames "data/medium_dict.txt" 8 50
  mediumDictResults `seq` return ()
  mediumEndTime <- getCPUTime
  let mediumDictTime = (mediumEndTime - mediumStartTime)

  -- small dictionary test
  smallStartTime <- getCPUTime
  smallDictResults <- simulateGames "data/small_dict.txt" 8 50
  smallDictResults `seq` return ()
  smallEndTime <- getCPUTime
  let smallDictTime = (smallEndTime - smallStartTime)

  let testResult = smallDictTime < mediumDictTime && (mediumDictTime < largeDictTime)
  assertBool "Smaller dictionaries should run faster than larger dictionaries!" testResult

testWordSizes :: Test
testWordSizes = TestCase $ do 
  -- large word lengths test
  largeStartTime <- getCPUTime
  largeWordsResults <- simulateGames "data/medium_dict.txt" 8 50
  largeWordsResults `seq` return ()
  largeEndTime <- getCPUTime
  let largeWordsTime = (largeEndTime - largeStartTime)
  
  -- medium word lengths test
  mediumStartTime <- getCPUTime
  mediumWordsResults <- simulateGames "data/medium_dict.txt" 5 50
  mediumWordsResults `seq` return ()
  mediumEndTime <- getCPUTime
  let mediumWordsTime = (mediumEndTime - mediumStartTime)

  -- small word lengths test
  smallStartTime <- getCPUTime
  smallWordsResults <- simulateGames "data/medium_dict.txt" 3 50
  smallWordsResults `seq` return ()
  smallEndTime <- getCPUTime
  let smallWordsTime = (smallEndTime - smallStartTime)

  let testResult = smallWordsTime < mediumWordsTime && (mediumWordsTime < largeWordsTime)
  assertBool "Smaller words should run faster than larger words!" testResult

testNumberGames :: Test
testNumberGames = TestCase $ do 
  -- many games test
  manyStartTime <- getCPUTime
  manyGamesResults <- simulateGames "data/medium_dict.txt" 6 75
  manyGamesResults `seq` return ()
  manyEndTime <- getCPUTime
  let manyGamesTime = (manyEndTime - manyStartTime)
  
  -- some games test
  someStartTime <- getCPUTime
  someGamesResults <- simulateGames "data/medium_dict.txt" 6 25
  someGamesResults `seq` return ()
  someEndTime <- getCPUTime
  let someGamesTime = (someEndTime - someStartTime)

  -- few games test
  fewStartTime <- getCPUTime
  fewGamesResults <- simulateGames "data/medium_dict.txt" 6 5
  fewGamesResults `seq` return ()
  fewEndTime <- getCPUTime
  let fewGamesTime = (fewEndTime - fewStartTime)

  let testResult = fewGamesTime < someGamesTime && (someGamesTime < manyGamesTime)
  assertBool "Fewer game simulations should run faster than many simulated games!" testResult